/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import com.teammetallurgy.aquaculture.init.AquaBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class SirenModifier
extends NoLevelsModifier {
    private static final float ATTACK_BONUS = 1.5f;
    private static final float SPEED_BONUS = 5.0f;
    private static final Component MINING_SPEED = new TranslatableComponent(Util.m_137492_((String)"modifier", (ResourceLocation)new ResourceLocation("tcintegrations", "siren.mining_speed")));

    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        if (tool.hasTag(TinkerTags.Items.MELEE) && context.getAttacker().m_204029_(FluidTags.f_13131_) && !tool.isBroken()) {
            return damage * 1.5f;
        }
        return damage;
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getPlayer();
        if (player != null && !player.f_19853_.f_46443_ && !tool.isBroken()) {
            boolean isSubmerged;
            ServerPlayer sp = (ServerPlayer)player;
            boolean bl = isSubmerged = sp.m_5842_() && sp.m_20069_() && sp.m_20071_();
            if (isEffective && tool.hasTag(TinkerTags.Items.HARVEST) && isSubmerged) {
                event.setNewSpeed(event.getNewSpeed() + 5.0f * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED) * miningSpeedModifier);
            }
        }
    }

    @NotNull
    public InteractionResult afterBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slot) {
        BlockPos pos;
        BlockState blockState;
        Player player = context.m_43723_();
        Level mcLevel = context.m_43725_();
        if (player != null && !mcLevel.f_46443_ && !tool.isBroken() && (blockState = mcLevel.m_8055_(pos = context.m_8083_()).getToolModifiedState(context, ToolActions.HOE_TILL, false)) != null && context.m_43719_() != Direction.DOWN && mcLevel.m_46859_(pos.m_7494_()) && blockState == Blocks.f_50093_.m_49966_()) {
            mcLevel.m_7731_(pos, ((Block)AquaBlocks.FARMLAND.get()).m_49966_(), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus = 0.0f;
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            if (player != null && key == TooltipKey.SHIFT && player.m_204029_(FluidTags.f_13131_)) {
                bonus = (float)tool.getDamage() * 1.5f;
            }
            if (bonus > 0.0f) {
                this.addDamageTooltip(tool, bonus, tooltip);
            }
        }
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            if (player != null && key == TooltipKey.SHIFT && player.m_204029_(FluidTags.f_13131_)) {
                bonus = 5.0f;
            }
            if (bonus > 0.0f) {
                this.addFlatBoost(MINING_SPEED, bonus * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED), tooltip);
            }
        }
    }
}

